<?php

namespace App\Models\Tenants;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Address extends Model 
{

    protected $table = 'addresses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'home', 'mailing', 'fathers_house');
    protected $visible = array('user_id', 'home', 'mailing', 'fathers_house');

    public function user()
    {
        return $this->hasOne('App\User', 'user_id');
    }

}